<?php
	
	require_once("texte.php");
	
	// Wenn ein "Text" angefordert wird, soll dieser ausgegeben werden.
	// Welcher Text gemeint ist, wird anhand des bergebenen GET-Parameters "id" ermittelt
	if (($_GET['ausgabe'] == "text") && !empty($_GET['id']))
	{
		$id = $_GET['id'];
		echo $text[$id];
	}
	
	// Wenn ein "Artikel" angefordert wird, soll dieser ausgegeben werden.
	// Welcher Text gemeint ist, wird anhand des bergebenen GET-Parameters "id" ermittelt
	// Der gesamte Artikel wird aus der "ueberschrift" und dem eigntlichen "text" zusammengesetzt.
	if (($_GET['ausgabe'] == "artikel") && !empty($_GET['id']))
	{
		$id = $_GET['id'];
		global $artikel;
		
		$text = $artikel[$id]['ueberschrift']." ".$artikel[$id]['text'];
		//$text = get_artikel_text($id);
		//$text = text_aufbereiten_1($text);
		//$text = text_aufbereiten_2($text);
		echo $text;
	}
	
	// Wird ein Artikel-Text aus mehreren Einzel-Elementen zusammengesetzt, so ist es sinnvoll diese Elemente
	// durch ein geeignetes Trenn-Zeichen (z.B. einen Punkt) voneinander zu trennen.
	function get_artikel_text($id = 0)
	{
		$artikel_text = "";
		global $artikel;
		
		$ueberschrift = $artikel[$id]['ueberschrift'];
		$text = $artikel[$id]['text'];
		
		// Test ob letztes Zeichen der berschrift ein Punkt ist
		// Wenn ja: berschrift und Text einfach zusammenhngen
		if ( substr($ueberschrift, -1) == ".")
			$artikel_text = $ueberschrift." \n ".$text;
		// Wenn nicht: berschrift und Text durch einen Punkt trennen
		else
			$artikel_text = $ueberschrift.".\n ".$text;
			
		return $artikel_text;
	}
	
	// Diese Funktion entfernt HTML-Tags aus dem Text
	function text_aufbereiten_1($text = "")
	{
		$text = str_replace(">", "> ", $text);
		$text = strip_tags($text);
		return $text;
	}
	
	// Diese Funktion bereitet auszugebende Texte auf
	function text_aufbereiten_2($text = "")
	{
		// Ende der HTML-Tags um ein Leerzeichen erweitern.
		$text = str_replace(">", "> ", $text);
		
		// HTML-Tags entfernen
		$text = strip_tags($text);
		
		// HTML-Entitten in echte Zeichen umwandeln, z.B. &auml; -> 
		$text = html_entity_decode($text);
		
		// Anfuehrungszeichen entfernen
		$text = str_replace("\"","",$text);
		
		// &nbsp; in " " berfhren:
		$text = str_replace(chr(160)," ",$text);
		
		return $text;
	}

	
?>